<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->foreign(['order_id'], 'trans_order')->references(['id'])->on('orders')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign(['subscription_id'], 'trans_subscrip')->references(['id'])->on('subscriptions')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign(['transaction_status_id'], 'trans_status')->references(['id'])->on('transaction_statuses')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign(['transaction_type_id'], 'trans_trans_type')->references(['id'])->on('transaction_types')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropForeign('trans_order');
            $table->dropForeign('trans_subscrip');
            $table->dropForeign('trans_status');
            $table->dropForeign('trans_trans_type');
        });
    }
};
