<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->foreign(['susbcription_status_id'], 'sub_sb_status')->references(['id'])->on('subscription_statuses')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign(['susbcription_type_id'], 'sub_sb_typ')->references(['id'])->on('subscription_types')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropForeign('sub_sb_status');
            $table->dropForeign('sub_sb_typ');
        });
    }
};
