<?php

namespace App\Http\Controllers\api\v1;

use App\Helpers\SerializerHelpers;
use App\Models\api\v1\AccessTokens;
use App\Models\api\v1\ApiKey;
use App\Models\User;
use App\Services\ApiKeyService;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;


class TransactionController extends Controller
{

    private function getFlexData(string $token): array
    {

        return $data = [
            "solde" => 30,
            'transactions' => [
                [
                    "id" => 124,
                    "montant"=> 10,
                    "type"=> "SORTANT",
                    "commentaire"=> "Test de paiement marchand",
                    "statut"=> "valide",
                    "etat"=> "valide",
                    "user"=> 720,
                    "ref"=> "pay659c20e5150ab",
                    "partenaire"=> 38,
                    "transaction"=> "transaction",
                    "created_at"=> "2024-01-08 16:20:53",
                    "updated_at"=> "2024-01-08 16:20:56",
                    "avantages"=> null,
                    "beneficiaire"=> "KY KADER",
                    "label"=> "KY KADER",
                    "nature"=> "Paiement",
                    "operateur"=> ""
                ],
                [
                    "id" => 122,
                    "montant"=> 10,
                    "type"=> "SORTANT",
                    "commentaire"=> "Test de paiement marchand",
                    "statut"=> "valide",
                    "etat"=> "valide",
                    "user"=> 720,
                    "ref"=> "con6598f531d6e66",
                    "partenaire"=> 38,
                    "transaction"=> "transaction",
                    "created_at"=> "2024-01-08 16:20:53",
                    "updated_at"=> "2024-01-08 16:20:56",
                    "avantages"=> null,
                    "beneficiaire"=> "KY KADER",
                    "label"=> "KY KADER",
                    "nature"=> "Paiement",
                    "operateur"=> ""
                ]
            ]
        ];

    }
    /**
     * Generate and Send Code
     */
    public function list(Request $request): JsonResponse
    {

        $get_authorized_api_key = ApiKey::where([['name', 'Flex'], ['is_active', 1]])->first();
        if (!$get_authorized_api_key)
        {
            return $this->ReturnResponse(false, "An error occurred. Please try again!", [], 401);
        }


        //@TODO:
        $access_token = AccessTokens::create([
            'user_id'               => $request->user()->id,
            'token'                 => Str::random(350),
            'created_by'            => $request->user()->id,
            'expire_at'             => now()->addSeconds(ApiKeyService::getApiKey($request)->token_max_interval),
            'requester_api_key_id'  => ApiKeyService::getApiKey($request)->id,
            'authorized_api_key_id' => $get_authorized_api_key->id,
            'used'                  => 0
        ]);

        $data = $this->getFlexData($access_token->token);

        return $this->ReturnResponse(true, "List Transactions", $data, 200);
    }


    public function userDetails(Request $request, string $token): JsonResponse
    {

        $access_token = AccessTokens::where([
            ['token',                   $token],
            ['used',                    0],
            ['expire_at',  '>=',        Carbon::now()],
            ['authorized_api_key_id',   ApiKeyService::getApiKey($request)->id]
        ])->first();

        if (!$access_token)
        {
            return $this->ReturnResponse(false, "Token is not valid", [], 401);
        }

        $user = User::find($access_token->user_id);

        $access_token->update([
            'used'      => 1,
            'used_at'   => now(),
        ]);

        return $this->ReturnResponse(true, "User Details", SerializerHelpers::serializeUser($user));

    }

}

