<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users_roles_spaces', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 250);
            $table->unsignedBigInteger('user_role_id')->nullable();
            $table->foreign('user_role_id')
                    ->references('id')
                    ->on('users_roles')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');

            $table->unsignedBigInteger('space_id')->nullable();
            $table->foreign('space_id')
                ->references('id')
                ->on('spaces')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->boolean('is_active')->default(true);
            $table->timestamp('created_at')->useCurrent();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->unsignedTinyInteger('is_deleted')->nullable()->default(0);
            $table->dateTime('deleted_at')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users_roles_spaces');
    }
};
