<?php

namespace App\Observers;

use App\Models\api\v1\Stock;

class StockObserver
{

    private function define_price_after_sale(Stock &$stock)
    {
        $percent                    = $stock->off_by_percentage ?  ($stock->off_by_percentage > 0 ? $stock->off_by_percentage / 100 : $stock->off_by_percentage) : 0;
        $off_by_number              = $stock->off_by_number ?? 0;

        $price_after_sale           = $stock->price  - ($stock->price  * $percent) -  $off_by_number;
        $stock->price_after_sale    = $price_after_sale > 0 ? $price_after_sale : 0;
    }
    /**
     * Handle the Stock "creating" event.
     */
    public function creating(Stock $stock): void
    {
       
        $this->define_price_after_sale($stock);
    }

     /**
     * Handle the Stock "updating" event.
     */
    public function updating(Stock $stock): void
    {
        $this->define_price_after_sale($stock);
    }

    /**
     * Handle the Stock "created" event.
     */
    public function created(Stock $stock): void
    {
        //
    }

    /**
     * Handle the Stock "updated" event.
     */
    public function updated(Stock $stock): void
    {
        //
    }

    /**
     * Handle the Stock "deleted" event.
     */
    public function deleted(Stock $stock): void
    {
        //
    }

    /**
     * Handle the Stock "restored" event.
     */
    public function restored(Stock $stock): void
    {
        //
    }

    /**
     * Handle the Stock "force deleted" event.
     */
    public function forceDeleted(Stock $stock): void
    {
        //
    }
}
