<?php

namespace App\Models;

use Auth;

use Exception;
use Twilio\Rest\Client;
use App\Models\api\v1\Role;
use Mediumart\Orange\SMS\SMS;
//use Laravel\Sanctum\HasApiTokens;
use App\Models\api\v1\UserRole;
use Illuminate\Support\Facades\DB;
use Laravel\Passport\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Mediumart\Orange\SMS\Http\SMSClient;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;


class User extends Authenticatable 
{
    use HasApiTokens, HasFactory, Notifiable;

    public $table = "users";

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = ['uuid','gender_id', 'country_id', 'username', 'password', 'email', 'email_verified_at', 'remember_token', 'lastname', 'firstname', 'phone_code', 'is_active', 'created_at',  'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    public $timestamps = true;


    /**
     * Scope Active
     */
    public function scopeActive($query) {
        return $query->where('users.is_active', '1');
    }


    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function gender()
    {
        return $this->belongsTo('App\Models\api\v1\Gender');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country()
    {
        return $this->belongsTo('App\Models\api\v1\Country');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function orders()
    {
        return $this->hasMany('App\Models\api\v1\Order', 'server_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function usersRoles()
    {
        return $this->hasMany('App\Models\api\v1\UserRole');
    }
        /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles()
    {
        return $this->belongsToMany(Role::class, 'users_roles', 'user_id', 'role_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function wallets()
    {
        return $this->hasMany('App\Models\api\v1\Wallet');
    }


    /**
     * Write code on Method
     *
     * @return response()
     */
    /*public function generateCode()
    {
        $code = rand(10000, 99999);
        // $code = '00000';
        $u = UserCode::updateOrCreate(
            ['user_id' => auth()->user()->id],
            ['code' => $code]
        );

        $receiverNumber = auth()->user()->phone;
        $message = "Votre code de vérification Carte Jeunes est " . $code;

        try {

            // $account_sid = getenv("TWILIO_SID");
            // $auth_token = getenv("TWILIO_TOKEN");
            // $twilio_number = getenv("TWILIO_FROM");

            // $client = new Client($account_sid, $auth_token);
            // $client->messages->create($receiverNumber, [
            //     'from' => $twilio_number,
            //     'body' => $message
            // ]);

            if (!auth()->user()->email_verified_at) {
                $client = SMSClient::getInstance('zu3dNEmkg38AWJn1gHZsGpymMIMmOXGZ', 'itVCvY2oItbOeSL4');
                $sms = new SMS($client);
                $sms->message($message)
                    ->from('+2250000', 'CarteJeunes')
                    ->to($receiverNumber)
                    ->send();
            }
        } catch (Exception $e) {
            dd("Error: " . $e->getMessage());
        }
    }*/

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
/*
    public function users_keys()
    {
        return $this->hasOne(Keys::class, 'id_users');
    }
    public function userCode()
    {
        return $this->hasOne(UserCode::class, 'user_id');
    }

    public function transaction_users()
    {
        return $this->hasMany(Transactions::class, 'id_users');
    }*/
}
