<?php

namespace App\Http\Controllers\api\v1;

use App\Models\api\v1\Item;
use Illuminate\Support\Str;
use App\Models\api\v1\Space;
use App\Models\api\v1\Stock;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\ItemResource;
use App\Models\api\v1\ProviderByCountry;
use App\Models\api\v1\UserRole;
use Illuminate\Support\Facades\Validator;

class ItemController extends Controller
{
    public function add(Request $request)
    {
        $data = [
            'id'                    => rand(1, 999),
            'item_id'               => rand(1, 999),
            'space_id'              => rand(1, 999),
            'price'                 => rand(1000, 999000),
            "off_by_percentage"     => 0,
            "off_by_number"         => 0,
            "quantity"              => rand(10, 99),
            "price_after_sale"      => 0,
            "is_active"             => 1,
            "created_at"            => date("Y-m-d H:i:s"),
            "created_by"            => 1,
            "item"                  =>  [
                "id"            => 3,
                "uuid"          => Str::uuid(),
                "name"          => "Test Item",
                "description"   => Str::random(1000),
                "img_1"         => "http://demo.lorem.com/test.jpg",
                "is_active"     => true,
                "created_at"    => date("Y-m-d H:i:s"),
            ]

        ];

        return $this->ReturnResponse(true, "Item created", $data);
    }

    public function getPromotionItemBySpace(Request $request, string $sapce_uuid)
    {

        $space = Space::where('uuid', $sapce_uuid)->first();

        if (!$space) {
            return $this->ReturnResponse(false, "Cet espace est introuvable", [], 404);
        }

        $stocks = Stock::where('space_id', $space->id)->pluck('item_id')->toArray();

        $items = Item::whereIn('id', $stocks)->where('is_on_promotion', 1)->get()->toArray();

        return $this->ReturnResponse(true, "Liste des articles disponibles", $items);
    }

    public function show(Request $request)
    {
        $data = [
            'id'                    => rand(1, 999),
            'space_id'              => rand(1, 999),
            "created_at"            => date("Y-m-d H:i:s"),
            "created_by"            => 1,
            "items"                  =>  [
                [
                    "id"            => rand(1, 99),
                    "uuid"          => Str::uuid(),
                    "name"          => "Test Item",
                    "description"   => Str::random(1000),
                    "img_1"         => "http://demo.lorem.com/test.jpg",
                    "is_active"     => true,
                    "created_at"    => date("Y-m-d H:i:s"),
                    "quantity"      => rand(0, 1990)
                ],
                [
                    "id"            => rand(1, 99),
                    "uuid"          => Str::uuid(),
                    "name"          => "Test Item 2",
                    "description"   => Str::random(1000),
                    "img_1"         => "http://demo.lorem.com/test.jpg",
                    "is_active"     => true,
                    "created_at"    => date("Y-m-d H:i:s"),
                    "quantity"      => rand(0, 1990)
                ],
                [
                    "id"            => rand(1, 99),
                    "uuid"          => Str::uuid(),
                    "name"          => "Test Item 3",
                    "description"   => Str::random(1000),
                    "img_1"         => "http://demo.lorem.com/test.jpg",
                    "is_active"     => true,
                    "created_at"    => date("Y-m-d H:i:s"),
                    "quantity"      => rand(0, 1990)
                ],

            ]

        ];
        if ($request->user_role_name == 'Client') {
            foreach ($data['items'] as &$dat) {
                unset($dat['quantity']);
            }
        }
        return $this->ReturnResponse(true, "Space's Stock", $data);
    }

    public function list(Request $request): JsonResponse
    {

        $validator = Validator::make(
            $request->all(),
            [
                'country_id'    => 'required|exists:countries,id',
                'provider_id'   => 'required|exists:providers,id',
            ]
        );
        //si erreur
        if ($validator->fails()) {
            return $this->ReturnResponse(false, $validator->errors(), [], 400);
        }


        $providerByCountry = ProviderByCountry::where([['country_id', $request->country_id], ['provider_id', $request->provider_id]])->first();
        $items = Item::where('provider_by_country_id', $providerByCountry->id ?? null)
            ->where('is_active', 1)
            ->get()->toArray();

        return $this->ReturnResponse(true, "Liste des articles disponibles", $items);
    }

    public function update(Request $request, string $uuid): JsonResponse
    {
        $data = [
            'id'                    => rand(1, 999),
            'item_id'               => rand(1, 999),
            'space_id'              => rand(1, 999),
            'price'                 => rand(1000, 999000),
            "off_by_percentage"     => 0,
            "off_by_number"         => 0,
            "quantity"              => rand(10, 99),
            "price_after_sale"      => 0,
            "is_active"             => 1,
            "created_at"            => date("Y-m-d H:i:s"),
            "created_by"            => 1,
            "item"                  =>  [
                "id"            => 3,
                "uuid"          => Str::uuid(),
                "name"          => "Test Item",
                "description"   => Str::random(1000),
                "img_1"         => "http://demo.lorem.com/test.jpg",
                "is_active"     => true,
                "created_at"    => date("Y-m-d H:i:s"),
            ]

        ];

        return $this->ReturnResponse(true, "Item updated", $data);
    }

    public function delete(Request $request, string $uuid): JsonResponse
    {

        return $this->ReturnResponse(true, "Item deleted");
    }
}
